#include <stdarg.h>
#include <stdlib.h>
#include <float.h>

#ifndef WIN32
#include <sys/param.h>
#include <sys/stat.h>
#endif

#ifdef WIN32
#pragma warning(disable: 4190)
#pragma warning(disable: 4800)
#endif /* WIN32 */

#include <maya/MStatus.h>
#include <maya/MObject.h>
#include <maya/MFnPlugin.h>
#include <maya/MString.h>
#include <maya/MStringArray.h>
#include <maya/MPxFileTranslator.h>
#include <maya/MGlobal.h>
#include <maya/MFnDagNode.h>
#include <maya/MItDag.h>
#include <maya/MObject.h>
#include <maya/MPlug.h>
#include <maya/MItSelectionList.h>
#include <maya/MSelectionList.h>
#include <maya/MAnimControl.h>
#include <maya/MDistance.h>
#include <maya/MFnSkinCluster.h>

#include <iostream.h>
#include <fstream.h>
#include <string.h>

#include <MDt.h>
#include <MDtExt.h>

#include <rpspline.h>
#include "rwcommon.h"
#include "mayaspl.h"
#include "global.h"

#ifdef WIN32
#define MAXPATHLEN 512
#endif

GlobalData *globalData;

/* ====================================== */
/* Get path name from a full path	 */
/* ====================================== */
char *
MDt_GetPathName (char *LFullStr, char *LRet, int LMaxLen)
{
    register int    LC;
    register int    LLen,
                    LLastSlashPos;

    LLastSlashPos = -1;
    for (LC = 0; LFullStr[LC] != '\0'; LC++)
    {
        if (LFullStr[LC] == '/')
            LLastSlashPos = LC;
    }

    LLen = LLastSlashPos + 1;

    if (LRet == NULL)
        return (NULL);

    LC = 0;
    if ((LRet != NULL) && ((LLen + 1) <= LMaxLen))
    {
        for (; LC < LLen; LC++)
            LRet[LC] = LFullStr[LC];
    }
    LRet[LC] = '\0';

    return (LRet);
}

GlobalData::GlobalData()
{
    m_scaleFactor           = 1.0f;
}

void* splTranslator::creator()
{
    return new splTranslator();
}


/* The reader is not implemented yet. And probably never will be */
MStatus splTranslator::reader (const MFileObject & file,
                                const MString & options,
                                MPxFileTranslator::FileAccessMode mode)
{
    MStatus rval (MS::kSuccess);

    return rval;
}

/* Write method of the spl translator / file exporter */
MStatus splTranslator::writer ( const MFileObject & fileObject,
                                const MString & options,
                                MPxFileTranslator::FileAccessMode mode)
{
    char            LTmpStr[MAXPATHLEN];
    const MString   fname = fileObject.fullName ();
    MString         extension;
    MString         baseFileName;
    char            SceneName[255];
    unsigned int    i;
    int             LN;
    MStatus         status;

    globalData = new GlobalData;

    /* Add the known extension of .spl if it isn't there. */
    extension.set (".spl");
    int  extLocation = fileObject.name ().rindex ('.');
    baseFileName = fileObject.name ();

    if (extLocation == 0)
    {
        /* add the extension */
        baseFileName = baseFileName + extension;
    }

    strcpy(SceneName, baseFileName.asChar());

    /* Process all the options in the options string */	
    if (options.length () > 0)
    {
        /* Parse each option */
        MStringArray optionList;
        MStringArray theOption;

        /* split up all the options.into a string array */
        options.split (';', optionList);

        for (i = 0; i < optionList.length (); ++i)
        {
            theOption.clear ();
            optionList[i].split ('=', theOption);
            if (theOption.length () > 1)
            {
                if (theOption[0] == MString ("splScaleFactor"))
                {
                    globalData->m_scaleFactor = (float) (theOption[1].asFloat ());
                }
            }
        }
    }

    /* Set the working directory to be the export
       destination */
    MDt_GetPathName ((char *) (fname.asChar ()), LTmpStr, MAXPATHLEN);

    LN = strlen (LTmpStr);
    if (LTmpStr[LN - 1] == '/')
    {
        LTmpStr[LN - 1] = '\0';
    }

    DtSetDirectory (LTmpStr);

    status = exportspl(SceneName);
    
    delete globalData;

    return status;

}

/* no read method */
bool splTranslator::haveReadMethod () const
{
    return false;
}

/* yes we can write */
bool splTranslator::haveWriteMethod () const
{
    return true;
}

/* what's the default extension */
MString splTranslator::defaultExtension () const
{
    return MString("spl");
}

bool splTranslator::canBeOpened () const
{
    return true;
}

/* we own files with .spl in their name */
MPxFileTranslator::MFileKind splTranslator::identifyFile (
             const MFileObject & fileName,
             const char *buffer,
             short size) const
{
    MFileKind rval = kNotMyFileType;

    if (strstr(fileName.fullName ().asChar(), ".spl"))
    {
        rval = kIsMyFileType;
    }
    return rval;
}

extern "C" MStatus 
initializePlugin (MObject obj)
{
    MStatus status;
    char    splVersion[100];

    sprintf(splVersion, "3.10 - %s", __DATE__);

    MFnPlugin plugin (obj, "Criterion Software", splVersion, "Any");

    /* Register the translator with the system */
    status = plugin.registerFileTranslator ("RenderWare spl",
                            "splTranslator.ico",
                             splTranslator::creator,
                            "splTranslatorOpts", "",
                            true);
    if (!status)
    {
        status.perror ("registerFileTranslator");
    }

    return status;
}

extern "C" MStatus 
uninitializePlugin (MObject obj)
{
    MStatus         status;
    MFnPlugin       plugin (obj);

    status = plugin.deregisterFileTranslator ("RenderWare spl");
    if (!status)
    {
        status.perror ("deregisterFileTranslator");
    }

    return status;
}

#ifdef WIN32
#pragma warning(default: 4190)
#pragma warning(default: 4800)
#endif /* WIN32 */
